VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CStringBuffer"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const STRING_BUFFER_SIZE As Long = 4096

'class member data
Private mlBufPos  As Long  'the physical position within the buffer
Private mlBufSize As Long  'the total preallocated buffer size
Private msBuf As String    'the buffer itself

Private Sub Class_Initialize()
'Initializes the buffer size and position.
    Clear
End Sub

Private Sub Class_Terminate()
'Cleans up the buffer, really unnecessary since VB will take care
    On Error Resume Next
    msBuf = vbNullString
End Sub
Public Sub Append(ByVal TheText As String)

Dim BytesToAppend As Long
    On Error GoTo ErrorHandler
    
    Dim TargetSize As Long

    BytesToAppend = Len(TheText)
    TargetSize = mlBufPos + BytesToAppend
    If TargetSize < mlBufSize Then
        Mid$(msBuf, mlBufPos, BytesToAppend) = TheText
        mlBufPos = TargetSize
    Else
        msBuf = msBuf & Space$(STRING_BUFFER_SIZE)
        mlBufSize = mlBufSize + STRING_BUFFER_SIZE
        Append TheText
    End If
Exit Sub

ErrorHandler:
    HandleError Err.Number, Err.Description, Err.Source, "CStringBuffer_Append"

End Sub
Public Property Get Value() As String
    Value = Left$(msBuf, mlBufPos - 1)
End Property

Public Property Let Value(NewValue As String)
    mlBufPos = 1
    Append NewValue
End Property
Public Sub Clear()
On Error GoTo ErrorHandler
'Initialize/reinitialize the buffer.
'Sets the buffer to an "empty" state.
    mlBufSize = STRING_BUFFER_SIZE
    msBuf = Space$(mlBufSize)
    mlBufPos = 1
    
Exit Sub

ErrorHandler:
    HandleError Err.Number, Err.Description, Err.Source, "CStringBuffer_Clear"

End Sub
Private Sub HandleError(lErrNumber As Long, sErrDesc As String, sErrSource As String, sOccurredIn As String)
    App.LogEvent "Error in " & sOccurredIn & " Number = " & lErrNumber & vbCrLf & " Description = " & sErrDesc & vbCrLf & " Source=" & sErrSource
    Err.Raise vbObjectError + lErrNumber, sErrSource & " : " & sOccurredIn, sErrDesc
End Sub

